<?php


function varn_setup(){
  // Add Menu Support
  add_theme_support('menus');

  // Add Thumbnail Theme Support
  // add_theme_support('post-thumbnails');
  // set_post_thumbnail_size( 1980, 990, array( 'center', 'center') ); // default Post Thumbnail dimensions (cropped)
  add_image_size('slider_begin', 1180, 442, true);
  add_image_size('6_9_large', 1140, 641, true);
  add_image_size('6_9_medium', 960, 540, true);
  add_image_size('6_9_small', 680, 383, true);


  add_image_size('4_3_large', 1140, 855, true);
  add_image_size('4_3_medium', 960, 720, true);
  add_image_size('4_3_small', 680, 510, true);

  add_image_size('logo', 300, '', true);
  add_theme_support( 'title-tag' );


  register_nav_menus(array( // Using array to specify more menus if needed
    'header-menu' => __('Header Menu', 'varn'), // Main Navigation
    'mobile-menu' => __('Mobile Menu', 'varn'), // Sidebar Navigation
    'footer-menu' => __('Footer Menu', 'varn') // Extra Navigation if needed (duplicate as many as you need!)
  ));
  if (!current_user_can('administrator') && !is_admin()) {
  show_admin_bar(false);
}
}



// Load any external files you have here

/*------------------------------------*\
Theme Support
\*------------------------------------*/

// Debug info
function debug($data) {
  //if(WP_ENV == 'local') {
  echo "<pre>";
  print_r($data);
  echo "</pre>";
  //  }
}

if (!isset($content_width))
{
  $content_width = 1600;
}

/*------------------------------------*\
Functions
\*------------------------------------*/

// Register varn Blank Navigation
function register_varn_menu()
{
  register_nav_menus(array( // Using array to specify more menus if needed
    'header-menu' => __('Header Menu', 'varn'), // Main Navigation
    'sidebar-menu' => __('Sidebar Menu', 'varn'), // Sidebar Navigation
    'extra-menu' => __('Extra Menu', 'varn') // Extra Navigation if needed (duplicate as many as you need!)
  ));
}

// Remove the <div> surrounding the dynamic navigation to cleanup markup
function my_wp_nav_menu_args($args = '')
{
  $args['container'] = false;
  return $args;
}

// Remove Injected classes, ID's and Page ID's from Navigation <li> items
function my_css_attributes_filter($var)
{
  return is_array($var) ? array() : '';
}

// Remove invalid rel attribute values in the categorylist
function remove_category_rel_from_category_list($thelist)
{
  return str_replace('rel="category tag"', 'rel="tag"', $thelist);
}

// Add body class
function add_slug_to_body_class($classes) {
  global $post;

  // Add page slug to body class, love this - Credit: Starkers Wordpress Theme
  if (is_home()) {
    $key = array_search('blog', $classes);
    if ($key > -1) {
      unset($classes[$key]);
    }
  } elseif (is_page()) {
    $classes[] = sanitize_html_class($post->post_name);
  } elseif (is_singular()) {
    $classes[] = sanitize_html_class($post->post_name);
  }

  // add sidebar classes
  $type = get_post_type();

  return $classes;
}




// Pagination for paged posts, Page 1, Page 2, Page 3, with Next and Previous Links, No plugin
function varn_pagination()
{
  global $wp_query;
  $big = 999999999;
  echo paginate_links(array(
    'base' => str_replace($big, '%#%', get_pagenum_link($big)),
    'format' => '?paged=%#%',
    'current' => max(1, get_query_var('paged')),
    'total' => $wp_query->max_num_pages
  ));
}

// Custom Excerpts
function varn_index($length) // Create 20 Word Callback for Index page Excerpts, call using varn_excerpt('varn_index');
{
  return 20;
}

// Create 40 Word Callback for Custom Post Excerpts, call using varn_excerpt('varn_custom_post');
function varn_custom_post($length)
{
  return 40;
}

// Create the Custom Excerpts callback
function varn_excerpt($length_callback = '', $more_callback = '')
{
  global $post;
  if (function_exists($length_callback)) {
    add_filter('excerpt_length', $length_callback);
  }
  if (function_exists($more_callback)) {
    add_filter('excerpt_more', $more_callback);
  }
  $output = get_the_excerpt();
  $output = apply_filters('wptexturize', $output);
  $output = apply_filters('convert_chars', $output);
  $output = '<p>' . $output . '</p>';
  echo $output;
}

// Remove Admin bar
function remove_admin_bar()
{
  return false;
}

// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
function remove_thumbnail_dimensions( $html )
{
  $html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);
  return $html;
}

/*------------------------------------*\
Actions + Filters + ShortCodes
\*------------------------------------*/

// Add Actions


add_action( 'after_setup_theme', 'varn_setup' );

add_action('init', 'varn_pagination'); // Add our varn Pagination


// Remove Actions
remove_action('wp_head', 'feed_links_extra', 3); // Display the links to the extra feeds such as category feeds
remove_action('wp_head', 'feed_links', 2); // Display the links to the general feeds: Post and Comment Feed
remove_action('wp_head', 'rsd_link'); // Display the link to the Really Simple Discovery service endpoint, EditURI link
remove_action('wp_head', 'wlwmanifest_link'); // Display the link to the Windows Live Writer manifest file.
remove_action('wp_head', 'index_rel_link'); // Index link
remove_action('wp_head', 'parent_post_rel_link', 10, 0); // Prev link
remove_action('wp_head', 'start_post_rel_link', 10, 0); // Start link
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0); // Display relational links for the posts adjacent to the current post.
remove_action('wp_head', 'wp_generator'); // Display the XHTML generator that is generated on the wp_head hook, WP version
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
remove_action('wp_head', 'rel_canonical');
remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);

add_filter('body_class', 'add_slug_to_body_class'); // Add slug to body class (Starkers build)
add_filter('widget_text', 'do_shortcode'); // Allow shortcodes in Dynamic Sidebar
add_filter('widget_text', 'shortcode_unautop'); // Remove <p> tags in Dynamic Sidebars (better!)
add_filter('wp_nav_menu_args', 'my_wp_nav_menu_args'); // Remove surrounding <div> from WP Navigation
add_filter('the_category', 'remove_category_rel_from_category_list'); // Remove invalid rel attribute
add_filter('the_excerpt', 'shortcode_unautop'); // Remove auto <p> tags in Excerpt (Manual Excerpts only)
add_filter('the_excerpt', 'do_shortcode'); // Allows Shortcodes to be executed in Excerpt (Manual Excerpts only)
add_filter( 'jpeg_quality', create_function( '', 'return 100;' ) );

// Remove Filters
remove_filter('the_excerpt', 'wpautop'); // Remove <p> tags from Excerpt altogether


$blank_includes = [
  /**
  * BC Extensions
  */

  'lib/bs/bc-protected-name.php',           // Protected name function

  'lib/bs/bc-query-controller.php',         // Control all queries

  'lib/bs/bc-truncate.php',                 // Truncate text

  'lib/bs/set-images.php',               // Set responsive imageries

  'lib/bs/bc-wp-core.php',                  // Custom tweaks on wordpress

  /**
  * ACF - Advanced Custom Fields ~ Pro
  */
  'lib/acf/options.php'                     // Custom tweaks on wordpress

];

//depicts where templates are found
foreach ($blank_includes as $file) {
  if (!$filepath = locate_template($file)) {
    trigger_error(sprintf(__('Error locating %s for inclusion', 'varn'), $file), E_USER_ERROR);
  }

  require_once $filepath;
} unset($file, $filepath);

//sets if full width or contained users choice
function pageWidth() {
  $full_width_or_fixed = get_field('full_width_or_fixed', 'option');
  echo $full_width_or_fixed;
}



/**
* Redirects users based on their role
*
* @since 1.0
* @author SFNdesign, Curtis McHale
*
* @uses wp_get_current_user()          Returns a WP_User object for the current user
* @uses wp_redirect()                  Redirects the user to the specified URL
*/
function cm_redirect_users_by_role() {
  if (is_user_logged_in() ) {
    $current_user   = wp_get_current_user();
    $role_name      = $current_user->roles[0];

    if ( 'webinars' === $role_name ) {
      wp_redirect(get_post_permalink('67'));
    } else if( 'toolkit' === $role_name ) {
      wp_redirect(get_post_permalink('223'));
    }
  }


} // cm_redirect_users_by_role
add_action( 'admin_init', 'cm_redirect_users_by_role' );

wp_oembed_add_provider( '/https?:\/\/(.+)?(wistia.com|wi.st)\/(medias|embed)\/.*/', 'http://fast.wistia.com/oembed', true);
