<?php get_header(); ?>
<?php
$main_description = get_field('main_description');
$transcript_attachment = get_field('transcript_attachment');
$mp3_audio_attachment = get_field('mp3_audio_attachment');
$care_resources = get_field('care_resources');
$competition_number = get_field('competition_number');
$video_link = get_field('video_link');
?>
<section id="content" role="main" class='individual-webinar'>
  <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
      <div class='breadcrumb clear  island-bottom-half  col-12'>
        <a class='inline' href='/gls-webinars'>GLS Webinars</a> <i class="fa fa-chevron-right" aria-hidden="true"></i> <?php echo the_title(); ?>
      </div>

      <section class="entry-content island-bottom overflow clear">
        <div class='col-12 col-4-m right'>
          <h1 class="entry-title"><?php the_title(); ?></h1>
        </hr>
        <?php if($main_description): ?>
        <div class='main-desc'>
          <?php echo $main_description; ?>
        </div>
      <?php endif; ?>

      <?php if($transcript_attachment):?>
        <a class='download-button' target='_blank' href='<?php echo $transcript_attachment['url']; ?>'>Download Transcript<i class="fa fa-chevron-down" aria-hidden="true"></i></a>
      <?php endif; ?>

      <?php if($mp3_audio_attachment):?>
        <div class="embed-container">
          <?php the_field('mp3_audio_attachment'); ?>
        </div>
        <p class='right island-half'>
          Play audio only
        </p>
      <?php endif; ?>



    </div>
    <div class='col-12 col-8-m'>
      <?php if($video_link):?>
        <div class='img island-half-bottom video-image'>


          <div class="embed-container">
            <?php the_field('video_link'); ?>
          </div>


        </div>
      <?php endif; ?>
    </div>
    <div class='col-12 clear island-top'>
      <?php if($competition_number):?>
        <?php echo do_shortcode("[WpProQuiz $competition_number]"); ?>
      <?php endif; ?>
    </div>

  </section>
  <!-- attachments -->
  <section class='clear island-bottom-margin'>
    <?php if( have_rows('care_resources') ): ?>

      <div class="gls-webinar ">

        <?php while( have_rows('care_resources') ): the_row();

        // vars
        $add_webinars_pdf = get_sub_field('add_webinars_pdf');
        $attachment_name = get_sub_field('attachment_name');
        ?>

        <div class="col-12 col-4-m downloads">
          <a target='_blank' href='<?php echo $add_webinars_pdf['url'];?>'>
            <div class='inner' data-match-height="web-height">
              <?php if($add_webinars_pdf && $attachment_name):?>
                <i class="fa fa-file-pdf-o" aria-hidden="true"></i><span class='attachement'><?php echo $attachment_name; ?></span>
              <?php endif; ?>
            </div>
          </a>
        </div>

      <?php endwhile; ?>

    </div>

  <?php endif; ?>
</section>
</article>
<?php endwhile; endif; ?>
</section>


<?php get_footer(); ?>
<!--single-gls_webinars.php-->
