<?php
$image_on_left_or_right = get_sub_field('image_on_left_or_right');
$add_a_link = get_sub_field('add_a_link');
$title = get_sub_field('title');
$add_a_link_to_something = get_sub_field('add_a_link_to_something');

$add_link_text = get_sub_field('add_link_text');
$image = get_sub_field('image');
$text_area = get_sub_field('text_area');
if($image_on_left_or_right == 'right') {
	$pos = 'right-m';
} else {
	$pos = '';
}

$sizes  = set_sizes_4_3_half($image);
$img_src = wp_get_attachment_image_url($image, '4_3_small' );

?>
<?php if($image):?>
		<section class='container island-bottom-margin'>
		<div class='fifty-fifty-image clear island-half island-light '>
			<div class='col-12 col-6-m <?php echo $image_on_left_or_right;?>'>
				<img src="/<?php echo esc_url( $img_src ); ?>" style="width:100%;"
        srcset="<?php echo esc_attr( $sizes ); ?>">
			</div>
			<div class='col-12 col-6-m'>
				<?php if($title):?>
					<h2><?php echo $title; ?></h2>
				<?php endif; ?>
				<?php if($text_area):?>
					<?php echo strip_tags($text_area, '<br><p><a>');;?>
				<?php endif;?>
        <?php if($add_a_link == 'true'):?>
          <?php if($add_a_link_to_something && $add_link_text):?>
            <a href='<?php echo get_the_permalink($add_a_link);?>'><?php echo $add_link_text;?></a>
          <?php endif;?>
        <?php endif; ?>
			</div>
		</div>
	</section>
<?php endif; ?>
