<?php $slider_options = get_sub_field('slider_options');
$pageWidth = 'container';
if(in_array('full', $slider_options)) {
  $pageWidth = '';
}
?>
<div class='<?php echo $pageWidth;?>'>
  <?php if( have_rows('add_new_slides') ): ?>

    <div class="slider-container">

      <?php while( have_rows('add_new_slides') ): the_row();

      // vars

      $slider_title = get_sub_field('slider_title');
      $slider_image = get_sub_field('slider_image');
      $slider_description = get_sub_field('slider_description');
      $link_to_pagepost = get_sub_field('link_to_pagepost');

      $sizes  = slider($slider_image);
      $img_src = wp_get_attachment_image_url($slider_image, '6_9_small' );

      ?>
      <div class='picture-wrapper relative'>
        <img src="/<?php echo esc_url( $img_src ); ?>" style="width:100%;"
        srcset="<?php echo esc_attr( $sizes ); ?>">

        <?php if(in_array('title', $slider_options) && $slider_title):?>
          <h2><?php echo $slider_title; ?></h2>
        <?php endif; ?>

        <?php if(in_array('description', $slider_options) && $slider_description):?>
          <div class='description'><?php echo $slider_description; ?></div>
        <?php endif; ?>

        <?php if(in_array('description', $slider_options) && $slider_description):?>
          <div class='description'><?php echo $slider_description; ?></div>
        <?php endif; ?>

        <?php if(in_array('link', $slider_options) && $link_to_pagepost):?>
          <a href="<?php echo the_permalink($link_to_pagepost); ?>">Learn more</a>
        <?php endif; ?>

      </div>
    <?php endwhile; ?>

  </div>
</div>
<?php endif; ?>
